/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;

public final class ComponentFactory {
    public static AbstractButton getRadioButton(Action action) {
        JRadioButton jRadioButton = new JRadioButton(action);
        ComponentFactory.connectActionAndButton(action, jRadioButton);
        return jRadioButton;
    }

    public static AbstractButton getToggleButton(Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        ComponentFactory.connectActionAndButton(action, jToggleButton);
        return jToggleButton;
    }

    public static JMenuItem getRadioMenuItem(Action action) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
        ComponentFactory.connectActionAndButton(action, jRadioButtonMenuItem);
        return jRadioButtonMenuItem;
    }

    public static JMenuItem getCheckBoxMenuItem(Action action) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(action);
        ComponentFactory.connectActionAndButton(action, jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    private static void connectActionAndButton(Action action, AbstractButton abstractButton) {
        SelectionStateAdapter selectionStateAdapter = new SelectionStateAdapter(action, abstractButton);
        selectionStateAdapter.configure();
    }

    private static class SelectionStateAdapter
    implements PropertyChangeListener,
    ItemListener {
        private Action action;
        private AbstractButton button;

        public SelectionStateAdapter(Action action, AbstractButton abstractButton) {
            this.action = action;
            this.button = abstractButton;
        }

        protected void configure() {
            this.action.addPropertyChangeListener(this);
            this.button.addItemListener(this);
            this.button.setSelected(this.action.getValue("actionConstants.selected").equals(Boolean.TRUE));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            Boolean bl2 = bl;
            this.action.putValue("actionConstants.selected", bl2);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("actionConstants.selected")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setSelected(bl);
            }
        }
    }
}

